/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.SDKFileEditorManager;
import java.awt.BorderLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SDKFileEditorTab
extends JPanel
implements DocumentListener {
    private JTextArea textArea;
    private JScrollPane scrollPanel;
    private File lFile;
    private String name;
    private boolean saveNeeded = false;

    public SDKFileEditorTab() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea("Please enter your own program here!");
        this.scrollPanel = new JScrollPane(this.textArea);
        this.textArea.getDocument().addDocumentListener(this);
        this.lFile = null;
        this.add(this.scrollPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDKFileEditorTab(File file) {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.textArea.append(string + "\n");
            }
        }
        catch (Exception exception) {
            this.textArea.append("\n" + exception.getClass().getName() + " Error: " + exception.getMessage() + "\n");
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        this.textArea.getDocument().addDocumentListener(this);
        this.scrollPanel = new JScrollPane(this.textArea);
        this.add(this.scrollPanel);
        this.lFile = file;
    }

    public boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    public void saveFile() {
        if (this.saveNeeded && this.saveToFile(this.lFile)) {
            this.saveNeeded = false;
            JTabbedPane jTabbedPane = SDKFileEditorManager.getPanel();
            String string = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());
            if (string.startsWith(" *")) {
                jTabbedPane.setTitleAt(jTabbedPane.getSelectedIndex(), string.substring(2));
            }
        }
    }

    public boolean saveToAnotherFile(File file) {
        this.lFile = file;
        if (this.saveToFile(this.lFile)) {
            this.saveNeeded = false;
            return true;
        }
        return false;
    }

    private boolean saveToFile(File file) {
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
            printWriter.print(this.textArea.getText());
            printWriter.close();
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "There was an I/O error while attempting to save the trace: " + iOException.getMessage());
            return false;
        }
    }

    public void setFileName(String string) {
        this.name = string;
    }

    public String getFileName() {
        if (this.lFile == null) {
            return this.name;
        }
        return this.lFile.getName();
    }

    public File getFile() {
        return this.lFile;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new UpdateEditorTabTitle());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new UpdateEditorTabTitle());
    }

    private class UpdateEditorTabTitle
    implements Runnable {
        private UpdateEditorTabTitle() {
        }

        public void run() {
            if (!SDKFileEditorTab.this.saveNeeded) {
                SDKFileEditorTab.this.saveNeeded = true;
                JTabbedPane jTabbedPane = SDKFileEditorManager.getPanel();
                String string = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());
                String string2 = " *" + string;
                jTabbedPane.setTitleAt(jTabbedPane.getSelectedIndex(), string2);
            }
        }
    }
}

